	function PLOT_STEP_RESPONSE_Z(s)
 
	%	Plots the step response, s(nT).
 
	%	Toolbox for DIGITAL FILTERS USING MATLAB
	
	% 	Author: 		Lars Wanhammar 2005-05-04
	% 	Modified by: 	LW 2014-07-20 	
	% 	Copyright:		by authors - not released for commercial use
	% 	Version:		1 
	% 	Known bugs:		
	% 	Report bugs to:	Wanhammar@gmail.com

	%========================================================	
	% Standard settings
	fs = 16; 		% Font size
	lw = 2; 		% Linewidth
	fn = 'times'; 	% Font
	%========================================================
	color = 'b';			% Set color
	linetype = '-';
	x = [0:length(s)-1];
	x = x(:)';
    s = s(:)';
	xx = [x; x];
	yy = [zeros(1, length(x)); s];
	ax = newplot;
	hold on;
	aym = 0.1; %  This may be changed to get a neater plot
	plot(x, s, [color '.'], xx, yy, [color linetype],'linewidth', lw)
	stem(x,s,'filled')
	color = 'k';
	set(ax,'ylim',[floor(10*(min(s)-aym))/10 floor(10*(max(s)+aym))/10], ...
	'Xcolor', color,'fontsize',fs,'linewidth', 1, 'fontname', fn);
	set(ax,'xlim',[x(1)-1 x(end)+1], 'Ycolor', color);
	set(get(ax,'xlabel'),'string','{\itn}','fontsize',fs,'fontname', fn);
	set(get(ax,'ylabel'),'string','{\its}({\itnT})','fontsize', fs,'fontname', fn);
	grid on;
	hold off;
	box on;	
